/*******************************************************
Filename		:  	DW_geo_select.sql
Release 		:  	STORET c2.0B
SIR			:  	1504
Description		:  	Creates a web page section that allows the user to enter 
				geographic criteria to query Stations or Results. 
Author			:  	Joseph Wilson/Christine Tsang
Date			: 	June 20, 2003
				08-29-2003 -- added decimal degrees label to lat/long section
Comments		:  	Code was extracted from dw_result_criteria_geo.  Called from other procedures.
**********************************************************/
SET DEF OFF;

CREATE OR REPLACE PROCEDURE DW_geo_select AS

--used to generate state list
CURSOR cstate IS
SELECT pk_isn, state_name
FROM DI_GEO_STATE
order by country_code desc, state_name;

BEGIN
htp.print ('
<h4>Geographic Location</h4>
<center>Select a single type of location search that you wish to perform (state/county, latitude/longitude, or HUC).  Then enter the corresponding search criteria.</center>
<table BORDER COLS=2 WIDTH="100%" >
<tr><td width="25%"><input checked type=radio name="geographic" value="StateCounty" tabindex=1>State/County</td>
<td><table COLS=2 WIDTH="90%" >
<tr><td><b>State Name</b></td><td><b>County Name</b></td></tr>
<tr><td valign="top"><font face="Courier"><p>
 <select name="as_state" size="1" tabindex=2 style="font: 10pt/12pt COURIER" onChange="javascript:document.forms[1].geographic[0].checked=true;document.forms[1].as_county.value=''ALL'';document.forms[1].v_county_code.value=''ALL'';document.forms[1].as_huc.value=''ALL'';">
<option value="0">ALL');

	FOR state IN cstate LOOP
		htp.formSelectOption(state.state_name, cattributes => 'VALUE='||state.pk_isn);
	END LOOP;

htp.print('
</SELECT></font></td>
<td><font face="Courier"><p>
<textarea readonly name="as_county" wrap="virtual" row=2 cols=20 style="font: 10pt/12pt COURIER" onFocus="javascript:this.blur()">ALL</textarea>
</font>
<input type="button" value="Look Up" tabindex=3 onclick="openWin(''state'')" title="Opens a popup window for county selection">
<input type="hidden" name="v_county_code" value="ALL">
</td></tr></table>
</td></tr>
<tr><td><input type=radio name="geographic" value="LatLong" tabindex=4>Latitude/Longitude<br>&nbsp&nbsp&nbsp&nbsp(in decimal degrees)</td>
<td align=center><B>North Limit</B>
<BR>&nbsp
<font face="Courier">
<INPUT type="TEXT" NAME="MAX_LAT_DD" SIZE="10" value="90" tabindex=5 onChange="javascript:document.forms[1].geographic[1].checked=true;">
</font>
<font face="Courier">
<SELECT NAME="dir_maxlat" style="font: 10pt/12pt COURIER" tabindex=6>
<OPTION VALUE= SOUTH>S
<OPTION SELECTED VALUE= NORTH>N
</SELECT>
</font>
<BR>
<B>West Limit</B>
&nbsp &nbsp &nbsp &nbsp &nbsp &nbsp &nbsp &nbsp &nbsp &nbsp &nbsp &nbsp &nbsp &nbsp &nbsp &nbsp &nbsp &nbsp &nbsp
&nbsp &nbsp &nbsp &nbsp &nbsp &nbsp &nbsp &nbsp
<B>East Limit</B>
&nbsp
<BR>
<font face="Courier">
<INPUT TYPE="TEXT" NAME="MIN_LONG_DD" SIZE="10" value="180" tabindex=7 onChange="javascript:document.forms[1].geographic[1].checked=true;">
</font>
<font face="Courier">
<SELECT NAME="dir_minlong" style="font: 10pt/12pt COURIER" tabindex=8>
<OPTION VALUE= EAST>E
<OPTION SELECTED VALUE= WEST>W
</SELECT>
</font>
&nbsp &nbsp &nbsp &nbsp &nbsp &nbsp &nbsp &nbsp &nbsp &nbsp &nbsp &nbsp &nbsp &nbsp &nbsp &nbsp &nbsp &nbsp &nbsp
&nbsp &nbsp &nbsp &nbsp &nbsp
<font face="Courier">
<INPUT TYPE="TEXT" NAME="MAX_LONG_DD" SIZE="10" value="0" tabindex=9 onChange="javascript:document.forms[1].geographic[1].checked=true;">
</font>
<font face="Courier">
<SELECT NAME="dir_maxlong" style="font: 10pt/12pt COURIER" tabindex=10>
<OPTION VALUE= EAST>E
<OPTION SELECTED VALUE= WEST>W
</SELECT>
</font>
<BR>
&nbsp
<B>South Limit</B>
<BR>
&nbsp
<font face="Courier">
<INPUT TYPE="TEXT" NAME="MIN_LAT_DD" SIZE="10" value="0" tabindex=11 onChange="javascript:document.forms[1].geographic[1].checked=true;">
</font>
<font face="Courier">
<SELECT NAME="dir_minlat" style="font: 10pt/12pt COURIER" tabindex=12>
<OPTION VALUE= SOUTH>S
<OPTION SELECTED VALUE= NORTH>N
</SELECT>
</font>
</td></tr>
<tr><td><input type=radio name="geographic" value="HUC" tabindex=13>Drainage Basin/HUC</td>
<td><b>Cataloging Unit</b><br>
<font face= "Courier">
<input type="text" readonly value="ALL" name="as_huc" size="23" style="font: 10pt/12pt COURIER" onFocus="javascript:this.blur()">
</font>
<input type="button" value="Look Up" tabindex=14 onclick="openWin(''huc'')" title="Opens a popup window for HUC selection"></td></tr>
</table>
');

END;
/
SHOW ERRORS;
